/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncLink;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LinkManager {
    public static final double MAX_LINK_LENGTH = 512.0;
    private final Map<UUID, BlockPos> lastNodeMap = new HashMap<UUID, BlockPos>();

    public static Optional<LinkManager> get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        if (level != null) {
            return Optional.of(((Access)level).refurbishedFurniture$GetLinkManager());
        }
        return Optional.empty();
    }

    public void onNodeInteract(Level level, Player player, IElectricityNode node) {
        IElectricityNode n;
        IElectricityNode lastNode;
        if (node.isNodeConnectionLimitReached()) {
            return;
        }
        if (this.startLinking(node.getNodePosition(), level, player)) {
            return;
        }
        BlockPos previousPos = this.lastNodeMap.get(player.m_20148_());
        BlockEntity blockEntity = level.m_7702_(previousPos);
        IElectricityNode iElectricityNode = lastNode = blockEntity instanceof IElectricityNode ? (n = (IElectricityNode)blockEntity) : null;
        if (lastNode != null && lastNode != node) {
            if (lastNode.isSourceNode() && node.isSourceNode()) {
                return;
            }
            int linkLength = (int)(lastNode.getNodePosition().m_252807_().m_82554_(node.getNodePosition().m_252807_()) + 0.5);
            if ((double)linkLength <= 512.0) {
                this.lastNodeMap.remove(player.m_20148_());
                lastNode.connectToNode(node);
                if (player.m_6047_() && this.startLinking(node.getNodePosition(), level, player)) {
                    Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncLink(node.getNodePosition()));
                    return;
                }
                level.m_247517_(null, node.getNodePosition(), (SoundEvent)ModSounds.ITEM_WRENCH_CONNECTED_LINK.get(), SoundSource.BLOCKS);
                Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncLink(null));
            }
        }
    }

    private boolean startLinking(BlockPos pos, Level level, Player player) {
        if (!this.lastNodeMap.containsKey(player.m_20148_())) {
            this.lastNodeMap.put(player.m_20148_(), pos);
            level.m_247517_(null, pos, (SoundEvent)ModSounds.ITEM_WRENCH_SELECTED_NODE.get(), SoundSource.BLOCKS);
            Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncLink(pos));
            return true;
        }
        return false;
    }

    public void onPlayerTick(Player player) {
        UUID id = player.m_20148_();
        if (this.lastNodeMap.containsKey(id) && !player.m_21205_().m_150930_((Item)ModItems.WRENCH.get())) {
            this.lastNodeMap.remove(id);
            Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageSyncLink(null));
        }
    }

    public void onPlayerLoggedOut(Player player) {
        this.lastNodeMap.remove(player.m_20148_());
    }

    public static interface Access {
        public LinkManager refurbishedFurniture$GetLinkManager();
    }
}

